package w83a.w83aOperacionesPaso.w83aResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83a.w83aBeans.W83aResultadosBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidades.W83aUtilidadesComunes;
import w83a.w83aUtilidades.W83aUtilidadesExcel;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;
import w83a.w83aUtilidadesComunes.W83aUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83aTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83aTablaCuadroResultadosExcelAction extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
	    List lista=new ArrayList();
	    Map m = new HashMap();

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83aCuadroResultados.xls";
		InputStream inputStream = W83aTablaCuadroResultadosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        Map mapa = (HashMap)contexto.get("w83aMapResultadosBean");
        Map cab = (HashMap)contexto.get("w83aMapCabeceraResultadosBean");
        W83aResultadosBean resultadoBean = (W83aResultadosBean)contexto.get("w83aResultadosBean");
        Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())){
        	String porc=resultadoBean.getPorcentaje().replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
        W83aUtilidadesExcel excel = new W83aUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83aUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        //String provincia = W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        String provincia = usuario.getCodTerritorioDelegacion();       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83aClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)3);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloCuadroResultadosClasif_eu",idioma));
        titulo.append(" ");
        titulo.append("/");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloCuadroResultadosClasif_es",idioma));
        cell.setCellValue(titulo.toString());
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)10); 
        cell = row.getCell((short)0); 
       
        if ("0".equals(resultadoBean.getTerritorio())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.comautvascaentero",idioma)+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));		
        }
        else{
        	cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase()+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
        }
        
        row = sheet.getRow((short)11);
        if(resultadoBean.getPorcentaje()!=null && !"".equals(resultadoBean.getPorcentaje())){
	        cell = row.getCell((short)2); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.porcentajeSobreTotal",idioma)+": "+resultadoBean.getPorcentaje()+"%");
	        
        }
        
        row = sheet.createRow((short)13); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.datosgenerales",idioma));
        cell = row.createCell((short)8); 
        cell.setCellValue(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(resultadoBean.getFechaRegistroDefinitivo(),idioma), idioma));
        lista = (ArrayList)cab.get("cabecera");
        int numempresas=lista.size();
        int numcentros=0;
        int numvotos=0;
        int totalelectores=0;
        Iterator it;
        for (int i=0;i<lista.size();i++){
        	numcentros=numcentros+Integer.parseInt(((W83aResultadosBean)lista.get(i)).getNumcentros());
        	numvotos=numvotos+Integer.parseInt(((W83aResultadosBean)lista.get(i)).getTotalvotos());
        	totalelectores=totalelectores+Integer.parseInt(((W83aResultadosBean)lista.get(i)).getNumTrabajadores());
        }
     
        row = sheet.createRow((short)15); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numempresas",idioma));
        cell = row.createCell((short)3);
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(numempresas);
        cell = row.createCell((short)10); 
        cell2 = row.createCell((short)11); 
        sheet.addMergedRegion(new Region((short)15,(short)10,(short)15,(short)11)); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numcentros",idioma));
        cell = row.createCell((short)12);
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(numcentros);
       
        row = sheet.createRow((short)16); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalelectores",idioma));
        cell = row.createCell((short)3);
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(totalelectores);
        cell = row.createCell((short)5); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalvotantes",idioma));
        cell = row.createCell((short)7);
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(numvotos);
        cell = row.createCell((short)10); 
        cell2 = row.createCell((short)11); 
        sheet.addMergedRegion(new Region((short)16,(short)10,(short)16,(short)11)); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.porcentaje",idioma));
        cell = row.createCell((short)12); 
        if (totalelectores!=0){
        	cell.setCellValue(W83aUtilidades.porcentaje(numvotos,totalelectores));//+"%"
        }
        else{
        	cell.setCellValue(0);
        }
        cell.setCellStyle(stylePorcentajesDcha(excel));
        row = sheet.createRow((short)18); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numdeleg",idioma));
        
        row = sheet.createRow((short)20); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.hasta49",idioma));
        cell = row.createCell((short)2);
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(Integer.parseInt(String.valueOf(mapa.get("delegadosmenorigual49"))));
        cell = row.createCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.demasde49",idioma));
        cell = row.createCell((short)6);
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(Integer.parseInt(String.valueOf(mapa.get("delegadosmayor49"))));
        cell = row.createCell((short)8); 
        cell2 = row.createCell((short)9); 
        sheet.addMergedRegion(new Region((short)20,(short)8,(short)20,(short)9)); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase());
        cell = row.createCell((short)10); 
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(Integer.parseInt(String.valueOf(mapa.get("delegadosmenorigual49")))+Integer.parseInt(String.valueOf(mapa.get("delegadosmayor49"))));
        
        row = sheet.createRow((short)22); 
        cell = row.createCell((short)3); 
        cell.setCellValue("*"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.rescentrales",idioma)+"*");
        int contador=0;
        int numdelegados=0;
        int numdelegadospu=0;
        int numdelegadospr=0;
        int numdelegadospriv=0;
        int numdelegadospubl=0;
        int numdelegadostotal=0;
        if (!"0".equals(resultadoBean.getTerritorio())){
        	row = sheet.createRow((short)23); 
        	cell = row.createCell((short)8); 
            cell2 = row.createCell((short)9); 
            cell3 = row.createCell((short)10);  
            sheet.addMergedRegion(new Region(23,(short)8,23,(short)10)); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.representantes",idioma));
            cell.setCellStyle(bordeAbajo(excel));
            cell2.setCellStyle(bordeAbajo(excel));
            cell3.setCellStyle(bordeAbajo(excel));
        	row = sheet.createRow((short)24); 
            cell = row.createCell((short)1); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.central",idioma));
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)2); 
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)3); 
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)4); 
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)5); 
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)6);
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)8); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.func",idioma));
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)9); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.labo",idioma));
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)10); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
            cell.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)11); 
            cell.setCellValue("%");
            cell.setCellStyle(styleCentradoSubrayado(excel));
            String[] valores;
            m = new TreeMap((Map)mapa.get(resultadoBean.getTerritorio()));
            Set ref = m.keySet();
            for( it = ref.iterator(); it.hasNext();) {
            	String a=(String)it.next();
            	Map c=(HashMap)m.get(a);
            	if (c!=null){
            		if (c.get("F")!=null){
    		            numdelegadostotal=numdelegadostotal+Integer.parseInt((String)c.get("F"));
            		}
            		if (c.get("L")!=null){
            			numdelegadostotal=numdelegadostotal+Integer.parseInt((String)c.get("L"));
            		}
            	}
            }
            ref = m.keySet();
            int delegados=0;
            int func=0;
            int labo=0;
            int tot=0;
            
            boolean otros=false;
            //ordenar descendientemente
            int cont=0;
            
            SortedMap map = new TreeMap(java.util.Collections.reverseOrder());
            int numdelegadosUnico=0;
            for( it = ref.iterator(); it.hasNext();) {
            	cont++;
            	numdelegadosUnico=0;
            	String a=(String)it.next();
            	valores=a.split("\\|");
	            Map c=(HashMap)m.get(a);
	            if (c!=null){
		            if (c.get("F")!=null){
		            	numdelegadosUnico=numdelegadosUnico+Integer.parseInt((String)c.get("F"));
			       }
	        		if (c.get("L")!=null){
	        			numdelegadosUnico=numdelegadosUnico+Integer.parseInt((String)c.get("L"));
			       }
	        	}
	            map.put(W83aUtilidadesComunes.rellenarCeros(String.valueOf(numdelegadosUnico))+"#"+String.valueOf(cont),a);
	        }
          //fin ordenar descendientemente
         Iterator iterator = map.keySet().iterator();
         while (iterator.hasNext()) {
	        Object key = iterator.next();
	        String valorClave=(String)map.get(key);
	        numdelegados=0;
	     	numdelegadospr=0;
	     	numdelegadospu=0;
	     	
	     	String a=valorClave;
	     	row = sheet.createRow((short)25+contador); // Creacin de la fila 1
	        cell = row.createCell((short)1); 
	        valores=a.split("\\|");
	        Map c=(HashMap)m.get(valorClave);
	         if (c!=null){
		            if (c.get("F")!=null){
	     			numdelegados=Integer.parseInt((String)c.get("F"));
			            numdelegadospu=Integer.parseInt((String)c.get("F"));
			            numdelegadospubl=numdelegadospubl+numdelegados;
	     		}
	     		if (c.get("L")!=null){
	     			numdelegados=Integer.parseInt((String)c.get("L"));
			            numdelegadospr=Integer.parseInt((String)c.get("L"));
			            numdelegadospriv=numdelegadospriv+numdelegados;
	     		}
	         }
	         if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(numdelegadospu+numdelegadospr,numdelegadostotal)*100<porcentajeFiltro.floatValue()){
	         	delegados=delegados+numdelegadospu+numdelegadospr;
	         	if (c.get("F")!=null){
	         	func=func+Integer.parseInt((String)c.get("F"));
	         	}
	         	if (c.get("L")!=null){
	         	labo=labo+Integer.parseInt((String)c.get("L"));
	         	}
	         	tot=tot+numdelegadospu+numdelegadospr;
	         	otros=true;
	         }
	         else{
		            if ("null".equals(valores[0])||valores[0]==null){
		            	cell.setCellValue("");
		            }
		            else{
		            	cell.setCellValue(valores[0]);
		            }
		            cell = row.createCell((short)2); 
		            if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
		            	if ("null".equals(valores[1])||valores[1]==null){
		            		cell.setCellValue("");
		            	}
		            	else{
		            		cell.setCellValue(valores[1]);
		            	}
		            }
		            else{
		            	if ("null".equals(valores[2])||valores[2]==null){
		            		cell.setCellValue("");
		            	}
		            	else{
		            		cell.setCellValue(valores[2]);
		            	}
		            	
		            }
		            cell2 = row.createCell((short)3);
		            cell3 = row.createCell((short)4);
		         
		            sheet.addMergedRegion(new Region((short)23+contador,(short)2,(short)23+contador,(short)6)); //NOPMD
		            inicializarCero(row, cell, 8);
		            inicializarCero(row, cell, 9);
		            inicializarCero(row, cell, 10);
	         	//Convenios
	         	
	         	if (c!=null){
	         		if (c.get("F")!=null){
	         			cell = row.createCell((short)8);
	         			cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	 		            cell.setCellValue(Integer.parseInt((String)c.get("F")));
	 		       }
	         		if (c.get("L")!=null){
	         			cell = row.createCell((short)9);
	         			cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	 		            cell.setCellValue(Integer.parseInt((String)c.get("L")));
	 		       }
	         	}
	         	cell = row.createCell((short)10);
	         	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	         	cell.setCellValue(numdelegadospu+numdelegadospr);
	         	cell = row.createCell((short)11);
	     		cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospu+numdelegadospr,numdelegadostotal));
	     		cell.setCellStyle(stylePorcentajesDcha(excel));
	         	contador=contador+1;
	         }
         }
           if(otros){
            	row = sheet.createRow((short)25+contador);
            	//metemos la linea de otros
        		cell = row.createCell((short)2);
            	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase());
        		
            	cell = row.createCell((short)8);
            	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        		cell.setCellValue(func);
        		cell.setCellStyle(bordeAbajo(excel));
        		cell = row.createCell((short)9);
        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        		cell.setCellValue(labo);
        		cell.setCellStyle(bordeAbajo(excel));
        		cell = row.createCell((short)10);
        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        		cell.setCellValue(tot);
        		cell.setCellStyle(bordeAbajo(excel));
        		cell = row.createCell((short)11);
        		cell.setCellValue(W83aUtilidades.porcentaje(delegados,numdelegadostotal));
            	cell.setCellStyle(stylePorcentajesDcha(excel));
        		
        		
        		contador=contador+1;
            	
            }
            row = sheet.createRow((short)25+contador);
            cell = row.createCell((short)1); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase());
            cell.setCellStyle(bordeArriba(excel));
            cell = row.createCell((short)2); 
            cell.setCellStyle(bordeArriba(excel));
            cell = row.createCell((short)3); 
            cell.setCellStyle(bordeArriba(excel));
            cell = row.createCell((short)4); 
            cell.setCellStyle(bordeArriba(excel));
            cell = row.createCell((short)5); 
            cell.setCellStyle(bordeArriba(excel));
            cell = row.createCell((short)6); 
            cell.setCellStyle(bordeArriba(excel));
            cell = row.createCell((short)9);
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadospriv);
            cell = row.createCell((short)8); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadospubl);
            cell = row.createCell((short)10); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadospubl+numdelegadospriv);
        }else{
        	row = sheet.createRow((short)23); 
            cell = row.createCell((short)2); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.araba",idioma));
            cell = row.createCell((short)6); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.bizkaia",idioma));
            cell = row.createCell((short)10); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.gipuzkoa",idioma));
            cell = row.createCell((short)14); 
            cell2 = row.createCell((short)15);
            sheet.addMergedRegion(new Region(23,(short)14,23,(short)15));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.comautvasca",idioma));
            row = sheet.createRow((short)24); 
            cell = row.createCell((short)1);
            cell2 = row.createCell((short)2);
            sheet.addMergedRegion(new Region(24,(short)1,24,(short)2)); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase());
            cell.setCellStyle(bordeAbajo(excel));
            cell2.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)5); 
            cell2 = row.createCell((short)6); 
            sheet.addMergedRegion(new Region(24,(short)5,24,(short)6)); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase());
            cell.setCellStyle(bordeAbajo(excel));
            cell2.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)9); 
            cell2 = row.createCell((short)10); 
            sheet.addMergedRegion(new Region(24,(short)9,24,(short)10)); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase());
            cell.setCellStyle(bordeAbajo(excel));
            cell2.setCellStyle(bordeAbajo(excel));
            cell = row.createCell((short)13); 
            cell2 = row.createCell((short)14);
            sheet.addMergedRegion(new Region(24,(short)13,24,(short)14)); 
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase());
            cell.setCellStyle(bordeAbajo(excel));
            cell2.setCellStyle(bordeAbajo(excel));
            row = sheet.createRow((short)25); 
            cell = row.createCell((short)0); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.central",idioma));
            cell = row.createCell((short)1); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma));
            cell = row.createCell((short)2); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma));
            cell = row.createCell((short)3); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
            cell = row.createCell((short)4); 
            cell.setCellStyle(styleCentradoSubrayado(excel));
            cell.setCellValue("%");
            cell = row.createCell((short)5); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma));
            cell = row.createCell((short)6);
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma));
            cell = row.createCell((short)7); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
            cell = row.createCell((short)8);
            cell.setCellStyle(styleCentradoSubrayado(excel));
            cell.setCellValue("%");
            cell = row.createCell((short)9); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma));
            cell = row.createCell((short)10); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma));
            cell = row.createCell((short)11); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
            cell = row.createCell((short)12); 
            cell.setCellStyle(styleCentradoSubrayado(excel));
            cell.setCellValue("%");
            cell = row.createCell((short)13); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma));
            cell = row.createCell((short)14); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma));
            cell = row.createCell((short)15); 
            cell.setCellStyle(bordeAbajo(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
            cell = row.createCell((short)16); 
            cell.setCellStyle(styleCentradoSubrayado(excel));
            cell.setCellValue("%");
        	
            m = new TreeMap((Map)mapa.get("todos"));
            Set ref = m.keySet();
    		int ntpa=0;
    		int ntpb=0;
    		int ntpg=0;
    		int ntpra=0;
    		int ntprb=0;
    		int ntprg=0;
    		int nt=0;
    		for( it = ref.iterator(); it.hasNext();) {
    			String a=(String)it.next();
	            Map c=(HashMap)m.get(a);
	            if (c!=null){
	            	if (c.get("F")!=null){
            			Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				ntpa=ntpa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				ntpb=ntpb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				ntpg=ntpg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            		}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				ntpra=ntpra+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				ntprb=ntprb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				ntprg=ntprg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            		}
            		
	            }
	            nt=ntpa+ntpb+ntpg+ntpra+ntprb+ntprg;
            }
    		ref = m.keySet();
    		String[] valores;
    		int numdelegadospubla=0;
    		int numdelegadospublb=0;
    		int numdelegadospublg=0;
    		int numdelegadospriva=0;
    		int numdelegadosprivb=0;
    		int numdelegadosprivg=0;
    		int numdelegadostotpubla=0;
    		int numdelegadostotpublb=0;
    		int numdelegadostotpublg=0;
    		int numdelegadostotpriva=0;
    		int numdelegadostotprivb=0;
    		int numdelegadostotprivg=0;
    		int numdelegadospublapor=0;
    		int numdelegadospublbpor=0;
    		int numdelegadospublgpor=0;
    		int numdelegadosprivapor=0;
    		int numdelegadosprivbpor=0;
    		int numdelegadosprivgpor=0;
    		int numdelegadostotpublapor=0;
    		int numdelegadostotpublbpor=0;
    		int numdelegadostotpublgpor=0;
    		int numdelegadostotprivapor=0;
    		int numdelegadostotprivbpor=0;
    		int numdelegadostotprivgpor=0;
    		boolean otros=false;
    		//ordenar descencientemente
    		int cont=0;
            SortedMap map = new TreeMap(java.util.Collections.reverseOrder());
            for( it = ref.iterator(); it.hasNext();) {
            	cont++;
            	numdelegados=0;
            	numdelegadospr=0;
            	numdelegadospu=0;
            	int nuestroalava=0;
        		int nuestrovizcaya=0;
        		int nuestroguipuzcoa=0;
            	String a=(String)it.next();
	            valores=a.split("\\|");
	            Map c=(HashMap)m.get(a);
	            if (c!=null){
	            	if (c.get("F")!=null){
            			Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            		}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            		}
	        		
	            }
	            map.put(W83aUtilidadesComunes.rellenarCeros(String.valueOf(nuestroalava+nuestrovizcaya+nuestroguipuzcoa))+"#"+String.valueOf(cont),a);
	        }
    		//fin ordenar descendientemente
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
            	Object key = iterator.next();
            	String valorClave=(String)map.get(key);
    			numdelegadospubla=0;
        		numdelegadospublb=0;
        		numdelegadospublg=0;
        		numdelegadospriva=0;
        		numdelegadosprivb=0;
        		numdelegadosprivg=0;
        		int nuestroalava=0;
        		int nuestrovizcaya=0;
        		int nuestroguipuzcoa=0;
        		String a=valorClave;
            	row = sheet.createRow((short)26+contador); // Creacin de la fila 1
	            cell = row.createCell((short)0); 
	            valores=a.split("\\|");
	            Map c=(HashMap)m.get(a);
	            if (c!=null){
	            	if (c.get("F")!=null){
            			Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            		}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            		}
            	}
	            if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(nuestroalava+nuestrovizcaya+nuestroguipuzcoa,nt)*100<porcentajeFiltro.floatValue()){
	            	if (c!=null){
		            	if (c.get("F")!=null){
	            			Map t=(Map)c.get("F");
	            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	            				numdelegadospublg=numdelegadospublg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadospublgpor=numdelegadospublgpor+numdelegadospublg;
	            				numdelegadostotpublg=numdelegadostotpublg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadostotpublgpor=numdelegadostotpublgpor+numdelegadostotpublg;
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	            				numdelegadospublb=numdelegadospublb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadospublbpor=numdelegadospublbpor+numdelegadospublb;
	            				numdelegadostotpublb=numdelegadostotpublb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadostotpublbpor=numdelegadostotpublbpor+numdelegadostotpublb;
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	            				numdelegadospubla=numdelegadospubla+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadospublapor=numdelegadospublapor+numdelegadospubla;
	            				numdelegadostotpubla=numdelegadostotpubla+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadostotpublapor=numdelegadostotpublapor+numdelegadostotpubla;
	            			}
	            		}
	            		if (c.get("L")!=null){
	            			Map t=(Map)c.get("L");
	            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	            				numdelegadosprivg=numdelegadosprivg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadosprivgpor=numdelegadosprivgpor+numdelegadosprivg;
	            				numdelegadostotprivg=numdelegadostotprivg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadostotprivgpor=numdelegadostotprivgpor+numdelegadostotprivg;
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	            				numdelegadosprivb=numdelegadosprivb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadosprivbpor=numdelegadosprivbpor+numdelegadosprivb;
	            				numdelegadostotprivb=numdelegadostotprivb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadostotprivbpor=numdelegadostotprivbpor+numdelegadostotprivb;
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	            				numdelegadospriva=numdelegadospriva+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadosprivapor=numdelegadosprivapor+numdelegadospriva;
	            				numdelegadostotpriva=numdelegadostotpriva+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadostotprivapor=numdelegadostotprivapor+numdelegadostotpriva;
	            			}
	            		}
	            	}
	            	otros=true;
	            }
	            else{
	            
		            if ("null".equals(valores[0])||valores[0]==null){
		            	cell.setCellValue("");
		            }
		            else{
		            	cell.setCellValue(valores[0]);
		            }
		            inicializarCero(row, cell, 1);
		            inicializarCero(row, cell, 2);
		            inicializarCero(row, cell, 9);
		            inicializarCero(row, cell, 10);
		            inicializarCero(row, cell, 5);
		            inicializarCero(row, cell, 6);
		            
		            
		            if (c!=null){
		            	if (c.get("F")!=null){
	            			Map t=(Map)c.get("F");
	            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	            				cell = row.createCell((short)9); 
	            				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)));
	            				numdelegadospublg=numdelegadospublg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadostotpublg=numdelegadostotpublg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	            				cell = row.createCell((short)5);
	            				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)));
	            				numdelegadospublb=numdelegadospublb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadostotpublb=numdelegadostotpublb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	            				cell = row.createCell((short)1); 
	            				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA)));
	            				numdelegadospubla=numdelegadospubla+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadostotpubla=numdelegadostotpubla+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            			}
	            		}
	            		if (c.get("L")!=null){
	            			Map t=(Map)c.get("L");
	            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	            				cell = row.createCell((short)10); 
	            				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)));
	            				numdelegadosprivg=numdelegadosprivg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadostotprivg=numdelegadostotprivg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	            				cell = row.createCell((short)6);
	            				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)));
	            				numdelegadosprivb=numdelegadosprivb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadostotprivb=numdelegadostotprivb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	            				cell = row.createCell((short)2);
	            				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA)));
	            				numdelegadospriva=numdelegadospriva+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadostotpriva=numdelegadostotpriva+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            			}
	            		}
	            		cell = row.createCell((short)3);
	            		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        			cell.setCellValue(numdelegadospubla+numdelegadospriva);
	        			cell = row.createCell((short)4);
	        			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospubla+numdelegadospriva,ntpa+ntpra));
	        			 cell.setCellStyle(stylePorcentajesDcha(excel));
	            		cell = row.createCell((short)7);
	            		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            		cell.setCellValue(numdelegadospublb+numdelegadosprivb);
	        			cell = row.createCell((short)8);
	        			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublb+numdelegadosprivb,ntpb+ntprb));
	        			 cell.setCellStyle(stylePorcentajesDcha(excel));
	        			cell = row.createCell((short)11);
	        			cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        			cell.setCellValue(numdelegadospublg+numdelegadosprivg);
	        			cell = row.createCell((short)12);
	        			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublg+numdelegadosprivg,ntpg+ntprg));
	        			 cell.setCellStyle(stylePorcentajesDcha(excel));
		            }
		            cell = row.createCell((short)13);
		            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
		            cell.setCellValue(numdelegadospubla+numdelegadospublb+numdelegadospublg);
		            cell = row.createCell((short)14);
		            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
		            cell.setCellValue(numdelegadospriva+numdelegadosprivb+numdelegadosprivg);
		            cell = row.createCell((short)15);
		            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
		            cell.setCellValue(numdelegadospubla+numdelegadospublb+numdelegadospublg+numdelegadospriva+numdelegadosprivb+numdelegadosprivg);
		            cell = row.createCell((short)16); 
		            cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospubla+numdelegadospublb+numdelegadospublg+numdelegadospriva+numdelegadosprivb+numdelegadosprivg,nt));
		            cell.setCellStyle(stylePorcentajesDcha(excel));
		            contador=contador+1;
		        }//fin del else
            }
    		if(otros){
    			row = sheet.createRow((short)26+contador);
    			cell = row.createCell((short)0); 
    	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase());
    	        cell = row.createCell((short)1);
    	        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
				cell.setCellValue(numdelegadospublapor);
				cell = row.createCell((short)9);
				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
				cell.setCellValue(numdelegadospublgpor);
				cell = row.createCell((short)5); 
				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
				cell.setCellValue(numdelegadospublbpor);
				cell = row.createCell((short)2);
				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
				cell.setCellValue(numdelegadosprivapor);
				cell = row.createCell((short)10); 
				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
				cell.setCellValue(numdelegadosprivgpor);
				cell = row.createCell((short)6);
				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
				cell.setCellValue(numdelegadosprivbpor);
				
				cell = row.createCell((short)3);
				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    			cell.setCellValue(numdelegadospublapor+numdelegadosprivapor);
    			cell = row.createCell((short)4);
    			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublapor+numdelegadosprivapor,ntpa+ntpra));
    			 cell.setCellStyle(stylePorcentajesDcha(excel));
        		cell = row.createCell((short)7);
        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    			cell.setCellValue(numdelegadospublb+numdelegadosprivbpor);
    			cell = row.createCell((short)8);
    			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublbpor+numdelegadosprivbpor,ntpb+ntprb));
    			 cell.setCellStyle(stylePorcentajesDcha(excel));
    			cell = row.createCell((short)11);
    			cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    			cell.setCellValue(numdelegadospublgpor+numdelegadosprivgpor);
    			cell = row.createCell((short)12);
    			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublgpor+numdelegadosprivgpor,ntpg+ntprg));
    			cell.setCellStyle(stylePorcentajesDcha(excel));
    			 
    			cell = row.createCell((short)13);
    			cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            cell.setCellValue(numdelegadospublapor+numdelegadospublbpor+numdelegadospublgpor);
	            cell = row.createCell((short)14);
	            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            cell.setCellValue(numdelegadosprivapor+numdelegadosprivbpor+numdelegadosprivgpor);
	            cell = row.createCell((short)15);
	            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            cell.setCellValue(numdelegadospublapor+numdelegadospublbpor+numdelegadospublgpor+numdelegadosprivapor+numdelegadosprivbpor+numdelegadosprivgpor);
	            cell = row.createCell((short)16); 
	            cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublapor+numdelegadospublbpor+numdelegadospublgpor+numdelegadosprivapor+numdelegadosprivbpor+numdelegadosprivgpor,nt));
	            cell.setCellStyle(stylePorcentajesDcha(excel));
	            contador=contador+1; 
				
    	        
    		}
    	    row = sheet.createRow((short)26+contador);
            cell = row.createCell((short)0); 
            cell.setCellStyle(bordeArriba(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase());
            cell = row.createCell((short)1); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpubla);
            cell = row.createCell((short)2); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpriva);
            cell = row.createCell((short)3); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpubla+numdelegadostotpriva);
            cell = row.createCell((short)5);
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpublb);
            cell = row.createCell((short)6); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotprivb);
            cell = row.createCell((short)7);
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpublb+numdelegadostotprivb);
            cell = row.createCell((short)9); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpublg);
            cell = row.createCell((short)10);
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotprivg);
            cell = row.createCell((short)11); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpublg+numdelegadostotprivg);
            cell = row.createCell((short)13); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpubla+numdelegadostotpublg+numdelegadostotpublb);
            cell = row.createCell((short)14); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpriva+numdelegadostotprivb+numdelegadostotprivg);
            cell = row.createCell((short)15); 
            cell.setCellStyle(styleBordeArribaFormateado(excel));
            cell.setCellValue(numdelegadostotpubla+numdelegadostotpublg+numdelegadostotpublb+numdelegadostotpriva+numdelegadostotprivb+numdelegadostotprivg);
        	}
            
           	
        byte[] bytesExcel = W83aUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoCuadroResumenResultados.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	
	private void inicializarCero(HSSFRow row, HSSFCell cell, int num){//NOPMD
		cell = row.createCell((short)num);
    	cell.setCellValue(0);
	}
	
	
	private HSSFCellStyle bordeAbajo(W83aUtilidadesExcel excel){
		return excel.styleBordeAbajo;			
		
	}
	private HSSFCellStyle bordeArriba(W83aUtilidadesExcel excel){
		return excel.styleBordeArriba;			
		
	}
	private HSSFCellStyle stylePorcentajesDcha(W83aUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;			
		
	}
	private HSSFCellStyle styleBordeArribaFormateado(W83aUtilidadesExcel excel){
		return excel.styleBordeArribaFormateado;			
		
	}
	private HSSFCellStyle styleCentradoSubrayado(W83aUtilidadesExcel excel){
		return excel.styleCentradoSubrayado;			
		
	}

	private HSSFCellStyle styleDerechaNumeroFormateado(W83aUtilidadesExcel excel){
		return excel.styleDerechaNumeroFormateado;			
		
	}
}

